-- Evaluation for one player
local t = LoadActor(THEME:GetPathB("ScreenEvaluation","decorations"));

t[#t+1] = StandardDecorationFromFile("JudgeLabels","JudgeLabels")
t[#t+1] = StandardDecorationFromFile("DetailLabels","DetailLabels")
t[#t+1] = StandardDecorationFromFile("LegacyScoreLabel","LegacyScoreLabel")

-- 1p-specific crap begins here
local pn = GAMESTATE:GetMasterPlayerNumber()

t[#t+1] = LoadActor(THEME:GetPathG("ScreenGameplay","StepInfo"),pn)..{
	Name="StepInfo"..PlayerNumberToString(pn);
	InitCommand=function(self)
		ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen")
	end;
};

local function GraphDisplay( pn )
	local t = Def.ActorFrame {
		Def.GraphDisplay {
			InitCommand=cmd(Load,"GraphDisplay";);
			BeginCommand=function(self)
				local ss = SCREENMAN:GetTopScreen():GetStageStats();
				self:Set( ss, ss:GetPlayerStageStats(pn) );
			end
		};
	};
	return t;
end

t[#t+1] = StandardDecorationFromTable( "GraphDisplay" .. ToEnumShortString(pn), GraphDisplay(pn) )

return t